/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.cleanarch.bo.impl;

import de.planetensuche.datamodel.cleanarch.bo.api.IStar;
import de.planetensuche.datamodel.cleanarch.bo.api.types.MassType;
import java.util.Set;

public final class Star
implements IStar {
    private final Long id;
    private final Set<String> starNames;
    private final MassType massInSunTimes;

    private Star(Builder builder) {
        this.starNames = builder.starNames;
        this.massInSunTimes = builder.massInSunTimes;
        this.id = builder.id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public MassType getMassInSunTimes() {
        return this.massInSunTimes;
    }

    @Override
    public Set<String> getStarNames() {
        return this.starNames;
    }

    public static class Builder {
        private final Set<String> starNames;
        private Long id;
        private MassType massInSunTimes;

        public Builder(Set<String> set) {
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("star name is required");
            }
            this.starNames = set;
        }

        public Builder setId(Long l) {
            this.id = l;
            return this;
        }

        public Builder setMass(MassType massType) {
            this.massInSunTimes = massType;
            return this;
        }

        public IStar build() {
            return new Star(this);
        }
    }
}

