/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import de.planetensuche.datamodel.formeln.Konstanten;
import de.planetensuche.datamodel.formeln.SternleuchtkraftTemperatur;

public final class HabitateZoneKopparapu2013
extends Konstanten
implements IHabitateZone {
    private static final double S_EFFECTIVE_0_VENUS = 1.7753;
    private static final double S_EFFECTIVE_0_RUNNAWAY_GREENHOUSE = 1.0512;
    private static final double S_EFFECTIVE_0_EARLY_MARS = 0.3179;
    private static final double S_EFFECTIVE_0_MAX_GREENHOUSE = 0.3438;
    private static final double A_VENUS = 1.4316E-4;
    private static final double A_RUNNAWAY_GREENHOUSE = 1.3242E-4;
    private static final double A_MARS = 5.4513E-5;
    private static final double A_MAX_GREENHOUSE = 5.8942E-5;
    private static final double B_VENUS = 2.9875E-9;
    private static final double B_RUNNAWAY_GREENHOUSE = 1.5418E-8;
    private static final double B_MARS = 1.5313E-9;
    private static final double B_MAX_GREENHOUSE = 1.6558E-9;
    private static final double C_VENUS = -7.5702E-11;
    private static final double C_RUNNAWAY_GREENHOUSE = -7.9895E-11;
    private static final double C_MARS = -2.7786E-12;
    private static final double C_MAX_GREENHOUSE = -3.0045E-12;
    private static final double D_VENUS = -1.1635E-15;
    private static final double D_RUNNAWAY_GREENHOUSE = -1.8328E-15;
    private static final double D_MARS = -4.8997E-16;
    private static final double D_MAX_GREENHOUSE = -5.2983E-16;
    private final SternleuchtkraftTemperatur sternleuchtkraft = new SternleuchtkraftTemperatur();
    private double innereHZ;
    private double aeussereHZ;

    @Override
    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        double d;
        if (iPlanetensucheObjekt.isTemperaturUnbekannt()) {
            return false;
        }
        if (iPlanetensucheObjekt.getTemperatur() < 2600.0 || iPlanetensucheObjekt.getTemperatur() > 7200.0) {
            return false;
        }
        if (!(iPlanetensucheObjekt.isLeuchtkraftklasseUnbekannt() || "V".equals(iPlanetensucheObjekt.getLeuchtkraftklasse()) || "VI".equals(iPlanetensucheObjekt.getLeuchtkraftklasse()))) {
            return false;
        }
        if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            d = this.sternleuchtkraft.getLeuchtkraft(iPlanetensucheObjekt.getDurchmesser(), iPlanetensucheObjekt.getTemperatur());
        } else if (iPlanetensucheObjekt.isDurchmesserUnbekannt() && !iPlanetensucheObjekt.isAbsoluteHelligkeitUnbekannt()) {
            double d2 = Math.sqrt(Math.pow(10.0, -0.4 * (iPlanetensucheObjekt.getAbsoluteHelligkeit() - 4.82))) / Math.pow(iPlanetensucheObjekt.getTemperatur() / 5778.0, 2.0);
            d = this.sternleuchtkraft.getLeuchtkraft(d2, iPlanetensucheObjekt.getTemperatur());
        } else if (!iPlanetensucheObjekt.isMasseUnbekannt()) {
            d = this.sternleuchtkraft.getLeuchtkraft(iPlanetensucheObjekt.getMasse());
        } else {
            return false;
        }
        this.innereHZ = 0.0;
        this.aeussereHZ = 0.0;
        this.berechne(iPlanetensucheObjekt.getTemperatur(), d);
        return this.innereHZ > 0.0 && this.aeussereHZ > 0.0;
    }

    private void berechne(double d, double d2) {
        double d3 = d - 5778.0;
        double d4 = 1.0512 + 1.3242E-4 * d3 + 1.5418E-8 * Math.pow(d3, 2.0) + -7.9895E-11 * Math.pow(d3, 3.0) + -1.8328E-15 * Math.pow(d3, 4.0);
        double d5 = 0.3438 + 5.8942E-5 * d3 + 1.6558E-9 * Math.pow(d3, 2.0) + -3.0045E-12 * Math.pow(d3, 3.0) + -5.2983E-16 * Math.pow(d3, 4.0);
        this.innereHZ = Math.pow(d2 / d4, 0.5);
        this.aeussereHZ = Math.pow(d2 / d5, 0.5);
    }

    @Override
    public double getAeussereHZ() {
        return this.aeussereHZ;
    }

    @Override
    public double getInnereHZ() {
        return this.innereHZ;
    }
}

