/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;

public final class SternbildFinder {
    private static final String STERNBILDGRENZEN = new File("").getAbsolutePath() + File.separator + "database" + File.separator + "sternbildgrenzen.tsv";
    private final String[][] arr = new String[370][4];

    public SternbildFinder() throws IOException {
        this.ladeSternbilderGrenzen();
    }

    public String getSternbildCodeFuerKoordinate(double d, double d2) {
        double d3 = 0.2617993877991494;
        double d4 = Math.PI / 180;
        double d5 = d * d3;
        double d6 = d2 * d4;
        Double[] doubleArray = this.precess(d5, d6, 2000.0, 1875.0);
        d5 = doubleArray[0];
        d6 = doubleArray[1];
        d5 /= d3;
        d6 /= d4;
        for (int i = 0; i < this.arr.length; ++i) {
            double d7 = Double.parseDouble(this.arr[i][2]);
            double d8 = Double.parseDouble(this.arr[i][0]);
            double d9 = Double.parseDouble(this.arr[i][1]);
            if (!(d6 >= d7) || !(d5 >= d8) || !(d5 <= d9)) continue;
            return this.arr[i][3];
        }
        return null;
    }

    private Double[] precess(double d, double d2, double d3, double d4) {
        Double[] doubleArray = new Double[2];
        double d5 = Math.PI / 180;
        double d6 = d5 / 3600.0;
        double d7 = Math.cos(d2);
        Double[] doubleArray2 = new Double[]{d7 * Math.cos(d), d7 * Math.sin(d), Math.sin(d2)};
        double d8 = 0.001 * (d4 - d3);
        double d9 = 0.001 * (d3 - 1900.0);
        d7 = d6 * d8 * (23042.53 + d9 * (139.75 + 0.06 * d9) + d8 * (30.23 - 0.27 * d9 + 18.0 * d8));
        double d10 = d6 * d8 * d8 * (79.27 + 0.66 * d9 + 0.32 * d8) + d7;
        double d11 = d6 * d8 * (20046.85 - d9 * (85.33 + 0.37 * d9) + d8 * (-42.67 - 0.37 * d9 - 41.8 * d8));
        double d12 = Math.sin(d7);
        double d13 = Math.sin(d10);
        double d14 = Math.sin(d11);
        double d15 = Math.cos(d7);
        double d16 = Math.cos(d10);
        double d17 = Math.cos(d11);
        Double[][] doubleArray3 = new Double[3][3];
        doubleArray3[0][0] = d15 * d16 * d17 - d12 * d13;
        doubleArray3[0][1] = -d15 * d13 - d12 * d16 * d17;
        doubleArray3[0][2] = -d16 * d14;
        doubleArray3[1][0] = d12 * d16 + d15 * d13 * d17;
        doubleArray3[1][1] = d15 * d16 - d12 * d13 * d17;
        doubleArray3[1][2] = -d13 * d14;
        doubleArray3[2][0] = d15 * d14;
        doubleArray3[2][1] = -d12 * d14;
        doubleArray3[2][2] = d17;
        Double[] doubleArray4 = new Double[3];
        for (int i = 0; i < 3; ++i) {
            doubleArray4[i] = doubleArray3[i][0] * doubleArray2[0] + doubleArray3[i][1] * doubleArray2[1] + doubleArray3[i][2] * doubleArray2[2];
        }
        double d18 = Math.atan2(doubleArray4[1], doubleArray4[0]);
        if (d18 < 0.0) {
            d18 += Math.PI * 2;
        }
        double d19 = Math.asin(doubleArray4[2]);
        doubleArray[0] = d18;
        doubleArray[1] = d19;
        return doubleArray;
    }

    private void ladeSternbilderGrenzen() throws IOException {
        Object object;
        File file = new File(STERNBILDGRENZEN);
        if (!file.exists()) {
            object = this.getClass().getResource("../sternbildgrenzen.tsv");
            if (object != null) {
                String string = ((URL)object).getFile();
                string = string.replaceAll("%20", " ");
                file = new File(string);
            } else {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
        }
        object = Files.readLines(file, Charset.forName("UTF-8"));
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string = (String)iterator.next();
            if (string.startsWith("#") || (stringArray = string.split(";")).length != 4) continue;
            this.arr[n][0] = stringArray[0].trim();
            this.arr[n][1] = stringArray[1].trim();
            this.arr[n][2] = stringArray[2].trim();
            this.arr[n][3] = stringArray[3].trim();
            ++n;
        }
    }
}

