/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.MessageBar;
import de.planetensuche.guidesigner.components.SendWindowAccessToWebService;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import javax.swing.JFrame;

public abstract class Basisdialog
extends JFrame {
    private final ILogging logger = LoggingFactory.getLoggerForClass(Basisdialog.class);
    protected final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();
    private final MessageBar messageBar = new MessageBar();

    public Basisdialog(BasisdialogId basisdialogId) {
        this.init();
        new SendWindowAccessToWebService().sendAsyncWithoutException(basisdialogId);
    }

    public Basisdialog(String string, BasisdialogId basisdialogId) {
        this.init();
        this.setTitle(string);
        new SendWindowAccessToWebService().sendAsyncWithoutException(basisdialogId);
    }

    private void init() {
        this.setIconImage(IconPoolCustom.LOGO.getImageIcon().getImage());
        this.setDefaultCloseOperation(2);
    }

    protected void resizeToDesktopSize() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).left;
        int n2 = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).top;
        int n3 = this.getMaxDesktopWidth();
        int n4 = this.getMaxDesktopHeight();
        this.setBounds(n, n2, n3, n4);
    }

    protected void resizeToCenter(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n3 = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).left;
        int n4 = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).top;
        int n5 = this.getMaxDesktopWidth();
        int n6 = this.getMaxDesktopHeight();
        this.setBounds(n3 + (n5 - n) / 2, n4 + (n6 - n2) / 2, n, n2);
    }

    protected int getMaxDesktopHeight() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).top;
        int n2 = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).bottom;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (int)Math.round(dimension.getHeight()) - n - n2;
        return n3;
    }

    protected int getMaxDesktopWidth() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).left;
        int n2 = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).right;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (int)Math.round(dimension.getWidth()) - n - n2;
        return n3;
    }

    protected int getTopStartPixel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).top;
        return n;
    }

    protected int getLeftStartPixel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration).left;
        return n;
    }

    protected void showMessageBar(Object object) {
        this.getContentPane().add((Component)this.messageBar, object);
    }

    public IGuiDesigner getGuiDesigner() {
        return GuiDesignerFabrik.getInstance();
    }

    public ILogging getLogger() {
        return this.logger;
    }

    public ISprachcontainer getI18n() {
        return this.i18n;
    }

    public ISprachcontainer getSprachcontainer() {
        return this.i18n;
    }

    public void showMessageOnMessageBar(String string, IconPoolDefault iconPoolDefault) {
        this.messageBar.showMessageOnMessageBar(string, iconPoolDefault);
    }

    public void showMessageOnMessageBarByKey(String string, IconPoolDefault iconPoolDefault) {
        this.messageBar.showMessageOnMessageBar(this.i18n.getString(string), iconPoolDefault);
    }

    public void showMessageOnMessageBarByKey(String string, Exception exception, IconPoolDefault iconPoolDefault) {
        this.messageBar.showMessageOnMessageBar(this.i18n.getString(string) + " " + exception.toString(), iconPoolDefault);
    }
}

