/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public final class JComboBoxExtended<T>
extends JComboBox<String> {
    private final Map<String, T> values;

    public JComboBoxExtended() {
        this.values = new HashMap<String, T>();
    }

    public JComboBoxExtended(int n) {
        this.values = new HashMap<String, T>(n);
    }

    public void addItem(String string, T t) {
        super.addItem(string);
        this.values.put(string, t);
    }

    public void addItems(Collection<String> collection) {
        for (String string : collection) {
            super.addItem(string);
        }
    }

    public String getSelectedShowValue() {
        if (super.getSelectedItem() != null) {
            return (String)super.getSelectedItem();
        }
        return "";
    }

    public T getSelectedInternalValue() {
        if (super.getSelectedItem() != null) {
            String string = (String)super.getSelectedItem();
            return this.values.get(string);
        }
        return null;
    }

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        this.values.clear();
    }

    @Override
    public void removeItem(Object object) {
        super.removeItem(object);
        if (object instanceof String) {
            this.values.remove((String)object);
        }
    }
}

