/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public final class PictureFullsizeDialog
extends Basisdialog {
    private Image currentImage;
    private Image orginalImage;
    private int zoomAlgorithmus;
    private JMenu menu;
    private JMenuBar menueBar;
    private JMenuItem orginalSizeMenuItem;
    private JLabel pictureLabel;
    private JScrollPane scrollPane;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;

    public PictureFullsizeDialog(BasisdialogId basisdialogId, String string, ImageIcon imageIcon, int n) {
        super(basisdialogId);
        this.zoomAlgorithmus = n;
        this.initComponents();
        this.menu.setText(this.i18n.getString("db_m210"));
        this.orginalSizeMenuItem.setText(this.i18n.getString("db_gui103"));
        try {
            if (imageIcon != null) {
                this.setTitle(string);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setBounds(0, 0, dimension.width, dimension.height - 30);
                this.currentImage = imageIcon.getImage();
                this.pictureLabel.setIcon(new ImageIcon(this.currentImage));
                this.orginalImage = this.currentImage;
            }
        }
        catch (RuntimeException runtimeException) {
            this.getLogger().error(runtimeException);
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_f23") + " '" + string + "':\n" + runtimeException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.pictureLabel = new JLabel();
        this.menueBar = new JMenuBar();
        this.menu = new JMenu();
        this.zoomOutMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.orginalSizeMenuItem = new JMenuItem();
        this.setAlwaysOnTop(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                PictureFullsizeDialog.this.formKeyPressed(keyEvent);
            }
        });
        this.scrollPane.setViewportView(this.pictureLabel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.menu.setText("Bild");
        this.zoomOutMenuItem.setText("Zoom out (-)");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureFullsizeDialog.this.zoomOutMenuItemActionPerformed(actionEvent);
            }
        });
        this.menu.add(this.zoomOutMenuItem);
        this.zoomInMenuItem.setText("Zoom in (+)");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureFullsizeDialog.this.zoomInMenuItemActionPerformed(actionEvent);
            }
        });
        this.menu.add(this.zoomInMenuItem);
        this.orginalSizeMenuItem.setText("Orginalgroe\u00dfe (F4)");
        this.orginalSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureFullsizeDialog.this.orginalSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.menu.add(this.orginalSizeMenuItem);
        this.menueBar.add(this.menu);
        this.setJMenuBar(this.menueBar);
        this.setSize(new Dimension(400, 300));
        this.setLocationRelativeTo(null);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45) {
            this.zoomOutMenuItemActionPerformed(null);
        } else if (keyEvent.getKeyCode() == 521 || keyEvent.getKeyCode() == 107) {
            this.zoomInMenuItemActionPerformed(null);
        } else if (keyEvent.getKeyCode() == 115) {
            this.orginalSizeMenuItemActionPerformed(null);
        }
    }

    private void orginalSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.currentImage = this.orginalImage;
        this.pictureLabel.setIcon(new ImageIcon(this.currentImage));
    }

    private void zoomInMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            Image image;
            int n = 125;
            this.currentImage = image = this.currentImage.getScaledInstance(this.currentImage.getWidth(null) * n / 100, this.currentImage.getHeight(null) * n / 100, this.zoomAlgorithmus);
            this.pictureLabel.setIcon(new ImageIcon(this.currentImage));
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f98") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            Image image;
            int n = 75;
            this.currentImage = image = this.currentImage.getScaledInstance(this.currentImage.getWidth(null) * n / 100, this.currentImage.getHeight(null) * n / 100, this.zoomAlgorithmus);
            this.pictureLabel.setIcon(new ImageIcon(this.currentImage));
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f99") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }
}

