/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.PictureChangeListener;
import de.planetensuche.guidesigner.components.PictureFullsizeDialog;
import de.planetensuche.guidesigner.components.PictureViewerDataSource;
import de.planetensuche.guidesigner.components.PictureZoomCalculator;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.icons.IconPoolNavigation;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public final class PictureViewer
extends JPanel {
    private final ISprachcontainer sprache = SprachcontainerFabrik.getSprachcontainer();
    private final BasisdialogId basisdialogId;
    private final int pictureZoomAlgorithmus;
    private String currentPictureFilename;
    private int currentPictureNumber;
    private PictureChangeListener listener;
    private PictureViewerDataSource pictureViewerDataSource;
    private JButton fullsizeButton;
    private JLabel infoLabel;
    private JButton nextButton;
    private JComboBox pictureCombobox;
    private JLabel pictureLabel;
    private JButton previousButton;
    private JScrollPane scrollPane;
    private JToolBar toolBar;

    public PictureViewer(BasisdialogId basisdialogId, String string, PictureViewerDataSource pictureViewerDataSource) {
        this.pictureViewerDataSource = pictureViewerDataSource;
        this.basisdialogId = basisdialogId;
        this.pictureZoomAlgorithmus = this.getZoomAlgorithmusFromUserSettings(string);
        this.initComponents();
        this.toolBar.setFloatable(false);
        this.nextButton.setIcon(IconPoolNavigation.FORWARD.getImageIcon());
        this.nextButton.setText(null);
        this.previousButton.setIcon(IconPoolNavigation.BACK.getImageIcon());
        this.previousButton.setText(null);
        this.fullsizeButton.setIcon(IconPoolDefault.ZOOM_IN.getImageIcon());
        this.fullsizeButton.setText(null);
        this.initPictures();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PictureViewer.this.showCurrentPicture();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void setListener(PictureChangeListener pictureChangeListener) {
        this.listener = pictureChangeListener;
    }

    public JLabel getPictureLabel() {
        return this.pictureLabel;
    }

    private synchronized void initPictures() {
        if (this.pictureViewerDataSource.numberOfPictures() == 0) {
            this.pictureLabel.setText(this.sprache.getString("db_m141"));
            this.pictureLabel.setIcon(null);
            this.infoLabel.setText(null);
            this.pictureCombobox.removeAllItems();
            this.pictureCombobox.setEnabled(false);
            this.fullsizeButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        } else {
            this.pictureCombobox.setEnabled(true);
            this.pictureCombobox.removeAllItems();
            for (String string : this.pictureViewerDataSource.getPictureNames()) {
                this.pictureCombobox.addItem(string);
            }
            boolean bl = this.pictureViewerDataSource.numberOfPictures() > 1;
            this.nextButton.setEnabled(bl);
            this.previousButton.setEnabled(bl);
            this.fullsizeButton.setEnabled(true);
            this.currentPictureNumber = 0;
            this.currentPictureFilename = this.pictureViewerDataSource.getPictureName(this.currentPictureNumber);
        }
    }

    public void changePictures(PictureViewerDataSource pictureViewerDataSource) {
        this.pictureViewerDataSource = pictureViewerDataSource;
        this.initPictures();
    }

    public void showCurrentPicture() {
        if (this.pictureViewerDataSource.numberOfPictures() == 0) {
            return;
        }
        ImageIcon imageIcon = this.pictureViewerDataSource.getPicture(this.currentPictureNumber);
        if (imageIcon != null) {
            if (!this.pictureViewerDataSource.getPictureName(this.currentPictureNumber).endsWith(".gif")) {
                if (this.scrollPane.getWidth() == 0 || this.scrollPane.getHeight() == 0) {
                    this.scrollPane.setSize(this.getWidth(), this.getHeight());
                }
                int n = this.scrollPane.getWidth() - 10;
                int n2 = this.scrollPane.getHeight() - 10;
                PictureZoomCalculator pictureZoomCalculator = new PictureZoomCalculator();
                int n3 = imageIcon.getIconWidth();
                int n4 = imageIcon.getIconHeight();
                int n5 = pictureZoomCalculator.getZoomInPercent(n, n2, n3, n4);
                n3 = n3 * n5 / 100;
                n4 = n4 * n5 / 100;
                imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(n3, n4, this.pictureZoomAlgorithmus));
            }
            this.pictureLabel.setText(null);
            this.pictureLabel.setIcon(imageIcon);
            this.fullsizeButton.setEnabled(true);
        } else {
            this.fullsizeButton.setEnabled(false);
            this.pictureLabel.setText(this.sprache.getString("db_f22") + " " + this.sprache.getString("db_f24"));
            this.fullsizeButton.setEnabled(false);
        }
        this.infoLabel.setText(this.sprache.getString("db_m140") + " " + (this.currentPictureNumber + 1) + "/" + this.pictureViewerDataSource.numberOfPictures() + ": " + this.currentPictureFilename);
        if (this.listener != null) {
            this.listener.changePicture(this.currentPictureFilename);
        }
    }

    private int getZoomAlgorithmusFromUserSettings(String string) {
        int n = string.equals(this.sprache.getString("db_bild_schnell")) ? 2 : (string.equals(this.sprache.getString("db_bild_gut")) ? 4 : 1);
        return n;
    }

    public String getCurrentPictureFilename() {
        return this.currentPictureFilename;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.pictureLabel = new JLabel();
        this.toolBar = new JToolBar();
        this.pictureCombobox = new JComboBox();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.fullsizeButton = new JButton();
        this.infoLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView(this.pictureLabel);
        this.add((Component)this.scrollPane, "Center");
        this.toolBar.setRollover(true);
        this.pictureCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureViewer.this.pictureComboboxActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.pictureCombobox);
        this.previousButton.setText("<");
        this.previousButton.setFocusable(false);
        this.previousButton.setHorizontalTextPosition(0);
        this.previousButton.setVerticalTextPosition(3);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureViewer.this.previousButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.previousButton);
        this.nextButton.setText(">");
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureViewer.this.nextButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.nextButton);
        this.fullsizeButton.setText("fullsize");
        this.fullsizeButton.setFocusable(false);
        this.fullsizeButton.setHorizontalTextPosition(0);
        this.fullsizeButton.setVerticalTextPosition(3);
        this.fullsizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PictureViewer.this.fullsizeButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.fullsizeButton);
        this.add((Component)this.toolBar, "First");
        this.infoLabel.setText("Bild 1/5: andromedagalaxie.jpg");
        this.infoLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.add((Component)this.infoLabel, "Last");
    }

    private void fullsizeButtonActionPerformed(ActionEvent actionEvent) {
        PictureFullsizeDialog pictureFullsizeDialog = new PictureFullsizeDialog(this.basisdialogId, this.pictureViewerDataSource.getPictureName(this.currentPictureNumber), this.pictureViewerDataSource.getPicture(this.currentPictureNumber), this.pictureZoomAlgorithmus);
        pictureFullsizeDialog.setVisible(true);
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        if (this.currentPictureNumber < this.pictureViewerDataSource.numberOfPictures() - 1) {
            ++this.currentPictureNumber;
            this.currentPictureFilename = this.pictureViewerDataSource.getPictureName(this.currentPictureNumber);
            this.showCurrentPicture();
        }
    }

    private void previousButtonActionPerformed(ActionEvent actionEvent) {
        if (this.currentPictureNumber > 0) {
            --this.currentPictureNumber;
            this.currentPictureFilename = this.pictureViewerDataSource.getPictureName(this.currentPictureNumber);
            this.showCurrentPicture();
        }
    }

    private void pictureComboboxActionPerformed(ActionEvent actionEvent) {
        int n = this.pictureCombobox.getSelectedIndex();
        if (n > -1) {
            this.currentPictureNumber = n;
            this.currentPictureFilename = this.pictureViewerDataSource.getPictureName(this.currentPictureNumber);
            this.showCurrentPicture();
        }
    }
}

