/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components.search;

import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.guidesigner.components.search.EnterKeyListener;
import de.planetensuche.guidesigner.components.search.ItemSelectedListener;
import de.planetensuche.guidesigner.components.search.SearchTask;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;

public final class JComboBoxWithSearch
extends JComboBox<String> {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ItemSelectedListener selectionListener;
    private EnterKeyListener enterKeyListener;
    private boolean selectionDisabled;
    private SearchableDataSource searchableDataSource;

    public JComboBoxWithSearch() {
    }

    public JComboBoxWithSearch(SearchableDataSource searchableDataSource) {
        this.init(searchableDataSource);
    }

    public void init(SearchableDataSource searchableDataSource) {
        this.searchableDataSource = searchableDataSource;
        this.setEditable(true);
        this.setSelectedIndex(-1);
        this.setSelectedItem(null);
        this.setAutoscrolls(false);
        this.setLightWeightPopupEnabled(true);
        final JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setText("");
        jTextComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.isConsumed() || keyEvent.isControlDown() || !JComboBoxWithSearch.this.isRelevantKey(keyEvent) && keyEvent.getKeyCode() != 10) {
                    return;
                }
                String string = jTextComponent.getText();
                if (string == null || string.length() < 3) {
                    return;
                }
                keyEvent.consume();
                JComboBoxWithSearch.this.fireSearch(keyEvent.getKeyCode());
            }
        });
        this.addItemListener(itemEvent -> {
            int n = itemEvent.getStateChange();
            if (!this.selectionDisabled && n == 1) {
                Object object = itemEvent.getItem();
                if (this.selectionListener != null && object != null && this.isSelectedItemInList()) {
                    this.selectionListener.call(object.toString());
                }
            }
        });
    }

    public void fireSearch(int n) {
        String string = this.getText();
        if (!this.selectionDisabled && this.enterKeyListener != null && n == 10) {
            this.enterKeyListener.call(string);
        } else {
            this.selectionDisabled = true;
            this.executor.submit(new SearchTask(string, this.searchableDataSource, this));
        }
    }

    private boolean isRelevantKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127 || n == 8) {
            return true;
        }
        if (n == 45 || n == 521 || n == 46) {
            return true;
        }
        if (n >= 48 && n <= 57) {
            return true;
        }
        return n >= 65 && n <= 90;
    }

    public boolean isSelectedItemInList() {
        String string = this.getSelectedItem().toString();
        ComboBoxModel comboBoxModel = this.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!string.equals(comboBoxModel.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void setItemSelectedListener(ItemSelectedListener itemSelectedListener) {
        this.selectionListener = itemSelectedListener;
    }

    public void setEnterKeyListener(EnterKeyListener enterKeyListener) {
        this.enterKeyListener = enterKeyListener;
    }

    public void setSelectionDisabled(boolean bl) {
        this.selectionDisabled = bl;
    }

    public String getText() {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        return jTextComponent.getText();
    }
}

