/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater;

import com.google.common.io.Files;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.mutex.ProcessTypes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ProzessBlocker {
    private final ILogging logging = LoggingFactory.getLoggerForModule(Modulnummer.UPDATE);
    private File processesLog;
    private Map<String, String> keys;

    public ProzessBlocker() {
        try {
            this.keys = new HashMap<String, String>();
            this.keys.put(ProcessTypes.SIMMULATIONEN.getKey(), "Simulationen");
            this.keys.put(ProcessTypes.DATENBANK.getKey(), "Datenbank");
            this.keys.put(ProcessTypes.LEBEN.getKey(), "Leben");
            this.keys.put(ProcessTypes.FORMELSAMMLUNG.getKey(), "Formelsammlung");
            this.keys.put(ProcessTypes.UMRECHNER.getKey(), "Umrechner");
            this.keys.put(ProcessTypes.HAUPTPROGRAMM.getKey(), "Hauptprogramm");
            this.keys.put(ProcessTypes.BUGREPORT.getKey(), "Bugreport");
            this.keys.put(ProcessTypes.INSTALLER.getKey(), "Installer");
            this.processesLog = new File("temp" + File.separator + "processes.log");
            if (!this.processesLog.exists() && !this.processesLog.createNewFile()) {
                this.logging.warn("konnte Datei nicht erzeugen: '" + this.processesLog.getName() + "'");
            }
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
    }

    public boolean leereProzessLog() {
        boolean bl;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.processesLog, false), Charset.forName("UTF-8"));
        try {
            outputStreamWriter.write("");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                this.logging.error(iOException);
                return false;
            }
        }
        outputStreamWriter.close();
        return bl;
    }

    public List<String> getLaufendeProzesse() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<String> list = Files.readLines(this.processesLog, Charset.forName("UTF-8"));
            for (String string : list) {
                if (this.keys.get(string.trim()) == null) continue;
                arrayList.add(this.keys.get(string.trim()));
            }
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
        return arrayList;
    }
}

