/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.ProzessBlocker;
import de.planetensuche.updater.UpdateThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class UpdateGui
extends Basisdialog
implements IUpdateDialog {
    private final ISprachcontainer sprache;
    private final String planetensucheVersion;
    private final boolean testModus;
    private final int datenbankRamInMb;
    private Thread updateThread;
    private final KonfigurationDTO konfiguration;
    private JButton abbrechenButton;
    private JTextArea ausgabe;
    private JTextField fortschrittsText;
    private JScrollPane jScrollPane1;
    private JButton startenButton;
    private JLabel version;

    public UpdateGui(ISprachcontainer iSprachcontainer, String string, boolean bl, int n, boolean bl2, KonfigurationDTO konfigurationDTO) {
        super(BasisdialogId.UPDATER_HAUPTFENSTER);
        this.sprache = iSprachcontainer;
        this.planetensucheVersion = string;
        this.testModus = bl;
        this.datenbankRamInMb = n;
        this.konfiguration = konfigurationDTO;
        this.initComponents();
        this.setTitle(this.sprache.getString("up_fenster"));
        this.version.setText(this.sprache.getString("up_m37", this.planetensucheVersion));
        this.abbrechenButton.setText(this.sprache.getString("up_gui4"));
        this.startenButton.setText(this.sprache.getString("up_gui2"));
        this.startenButton.setToolTipText(this.sprache.getString("up_gui3"));
        this.appendOutput(this.sprache.getString("up_m2") + "\n" + this.sprache.getString("up_m3"));
        this.getGuiDesigner().addComponent(this.version, false);
        this.getGuiDesigner().addComponent(this.ausgabe, false);
        this.getGuiDesigner().addComponent(this.fortschrittsText, false);
        this.getGuiDesigner().addComponent(this.startenButton, false);
        this.getGuiDesigner().addComponent(this.abbrechenButton, false);
        if (bl2) {
            this.startenButtonActionPerformed(null);
        }
    }

    @Override
    public Component getDialog() {
        return this;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.ausgabe = new JTextArea();
        this.startenButton = new JButton();
        this.version = new JLabel();
        this.abbrechenButton = new JButton();
        this.fortschrittsText = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("Planetensuche Aktualisierungstool v1.2");
        this.setForeground(Color.white);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UpdateGui.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.ausgabe.setColumns(20);
        this.ausgabe.setEditable(false);
        this.ausgabe.setLineWrap(true);
        this.ausgabe.setRows(5);
        this.ausgabe.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.ausgabe);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 40, 400, 250);
        this.startenButton.setText("Update starten");
        this.startenButton.setToolTipText("Beenden Sie vorher Planetensuche!");
        this.startenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateGui.this.startenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.startenButton);
        this.startenButton.setBounds(270, 320, 140, 24);
        this.version.setText("verwendete Planetensuche-Version:");
        this.getContentPane().add(this.version);
        this.version.setBounds(10, 10, 320, 24);
        this.abbrechenButton.setText("abbrechen/beenden");
        this.abbrechenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateGui.this.abbrechenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.abbrechenButton);
        this.abbrechenButton.setBounds(120, 320, 140, 24);
        this.fortschrittsText.setEditable(false);
        this.fortschrittsText.setToolTipText("Downloadgeschwindigkeit");
        this.getContentPane().add(this.fortschrittsText);
        this.fortschrittsText.setBounds(10, 290, 400, 24);
        this.setSize(new Dimension(433, 392));
        this.setLocationRelativeTo(null);
    }

    public boolean sperreTool(boolean bl) {
        try {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File("looked"), false), Charset.forName("UTF-8"));){
                outputStreamWriter.write(Boolean.toString(bl));
            }
            return true;
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            return false;
        }
    }

    private void beenden() {
        this.getLogger().info("Update Modul closed...");
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.beenden();
    }

    private void startenButtonActionPerformed(ActionEvent actionEvent) {
        ProzessBlocker prozessBlocker = new ProzessBlocker();
        List<String> list = prozessBlocker.getLaufendeProzesse();
        boolean bl = true;
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(list.size());
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append(", ");
            }
            int n = JOptionPane.showConfirmDialog(this, this.sprache.getString("up_m4") + "\n" + stringBuilder.substring(0, stringBuilder.length() - 2) + "\n" + this.sprache.getString("up_m5") + "\n\n" + this.sprache.getString("up_m6"), this.sprache.getString("up_m6_titel"), 0, 2);
            if (n == 1) {
                bl = false;
            }
        }
        if (bl) {
            this.sperreTool(false);
            prozessBlocker.leereProzessLog();
            this.startenButton.setEnabled(false);
            this.abbrechenButton.setText(this.sprache.getString("up_gui1"));
            this.updateThread = new UpdateThread(this.planetensucheVersion, this, this.sprache, this.testModus, this.datenbankRamInMb, this.konfiguration);
            this.updateThread.start();
        }
    }

    @Override
    public void enableUpdateCancelButton(boolean bl) {
        this.abbrechenButton.setEnabled(bl);
    }

    @Override
    public void showDownloadSpeed(double d) {
        if (d > 0.0) {
            double d2 = d * 100.0;
            this.fortschrittsText.setText((double)Math.round(d2) / 100.0 + " " + this.sprache.getString("up_m7"));
        } else {
            this.fortschrittsText.setText("");
        }
    }

    private void abbrechenButtonActionPerformed(ActionEvent actionEvent) {
        if (this.startenButton.isEnabled()) {
            this.beenden();
            this.dispose();
            System.exit(0);
        } else {
            this.updateThread.interrupt();
            this.ausgabe.append("\n" + this.sprache.getString("up_m8") + "\n");
            this.abbrechenButton.setText(this.sprache.getString("up_gui4"));
            this.startenButton.setEnabled(true);
        }
    }

    @Override
    public void appendOutput(String string) {
        this.getLogger().info(string);
        if (this.ausgabe.getLineCount() >= 200) {
            this.ausgabe.replaceRange(null, 0, 100);
        }
        this.ausgabe.append(string + "\n");
        this.ausgabe.setCaretPosition(this.ausgabe.getDocument().getLength());
    }

    @Override
    public void updateDone() {
        this.abbrechenButton.setText(this.i18n.getString("up_gui4"));
        this.appendOutput(this.i18n.getString("up_m36"));
        this.startenButton.setEnabled(true);
    }
}

