/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.ps;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.UpdateThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;

public final class ZipDownloader {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(ZipDownloader.class);
    private final UpdateThread updateThread;
    private final ILogging logging;
    private final ISprachcontainer sprache;
    private final IUpdateDialog gui;
    private final String baseURL;

    public ZipDownloader(UpdateThread updateThread, ISprachcontainer iSprachcontainer, IUpdateDialog iUpdateDialog, boolean bl, KonfigurationDTO konfigurationDTO) {
        this.updateThread = updateThread;
        this.logging = LoggingFactory.getLoggerForModule(Modulnummer.UPDATE);
        this.sprache = iSprachcontainer;
        this.gui = iUpdateDialog;
        if (bl) {
            LOGGER.info("use test URL");
            this.baseURL = "https://www." + konfigurationDTO.getHomepageHostname() + "/pstest/";
        } else {
            LOGGER.info("use live URL");
            this.baseURL = "https://www." + konfigurationDTO.getHomepageHostname() + "/ps/";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download(String string, String string2, double d, List<String> list, List<Long> list2) {
        try {
            URL uRL = new URL(this.baseURL + string);
            try (InputStream inputStream = uRL.openStream();
                 FileOutputStream fileOutputStream = new FileOutputStream(string2);){
                int n;
                byte[] byArray = new byte[65535];
                int n2 = 0;
                int n3 = 19;
                long l = System.currentTimeMillis();
                while ((n = inputStream.read(byArray)) != -1) {
                    if (this.updateThread.isInterrupted()) {
                        File file = new File(string2);
                        if (!file.delete()) {
                            this.logging.warn("konnte defekte zip-Datei nicht loeschen!");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    fileOutputStream.write(byArray, 0, n);
                    n2 += n;
                    if (++n3 % 20 == 0) {
                        long l2 = System.currentTimeMillis() - l;
                        if (l2 > 0L) {
                            this.zeigeDownloadGeschwindigkeit(l2, n);
                        }
                        double d2 = (double)n2 / 1048576.0 * 100.0 / d;
                        int n4 = (int)(d2 * 100.0);
                        d2 = (double)n4 / 100.0;
                        this.zeigeDownloadFortschritt(n2, d2);
                    }
                    l = System.currentTimeMillis();
                }
                this.gui.appendOutput("Update (" + d + " MB) " + this.sprache.getString("up_m21") + "...\n");
                this.gui.showDownloadSpeed(0.0);
                int n5 = list.indexOf(string2);
                if (n5 > -1) {
                    long l3;
                    long l4 = this.getFingerabdruck(new File(string2));
                    if (l4 == (l3 = list2.get(n5).longValue())) {
                        this.gui.appendOutput("CRC ok...");
                        boolean bl = true;
                        return bl;
                    }
                    String string3 = "CRC-Error: zip '" + string2 + "' " + this.sprache.getString("up_m24") + " (" + l4 + "!=" + l3 + ")";
                    this.logging.warn(string3);
                    this.gui.appendOutput(string3);
                    return false;
                }
                String string4 = "Kein CRC32 fuer '" + string2 + "' gefunden!";
                this.logging.warn(string4);
                this.gui.appendOutput(string4);
                return false;
            }
        }
        catch (SocketException socketException) {
            this.logging.warn("download(" + string + "," + string2 + "," + d + ")", socketException);
            this.zeigeFehlermeldungWennDownloadFehlschlaegt(socketException);
            return false;
        }
        catch (IOException iOException) {
            this.logging.warn("download(" + string + "," + string2 + "," + d + ")", iOException);
            this.zeigeFehlermeldungWennDownloadFehlschlaegt(iOException);
        }
        return false;
    }

    private void zeigeFehlermeldungWennDownloadFehlschlaegt(IOException iOException) {
        JOptionPane.showMessageDialog(null, this.sprache.getString("up_m28_1") + " " + iOException.getLocalizedMessage() + "\n" + this.sprache.getString("up_m28_2"), this.sprache.getString("up_m8"), 2);
    }

    private void zeigeDownloadFortschritt(int n, double d) {
        if (n > 0x100000) {
            double d2 = (double)n / 1048576.0;
            this.gui.appendOutput((double)((int)(d2 *= 100.0)) / 100.0 + " MB " + this.sprache.getString("up_m19") + "... (" + d + "% " + this.sprache.getString("up_m20") + ")");
        } else {
            this.gui.appendOutput(n / 1024 + " KB " + this.sprache.getString("up_m19") + "... (" + d + "% " + this.sprache.getString("up_m20") + ")");
        }
    }

    private void zeigeDownloadGeschwindigkeit(long l, int n) {
        double d = 1000.0 / (double)l * ((double)n / 1024.0);
        if (d > 0.0 && d < 1048576.0) {
            this.gui.showDownloadSpeed(d);
        }
    }

    long getFingerabdruck(File file) {
        try {
            return FileUtils.checksumCRC32(file);
        }
        catch (IOException iOException) {
            this.logging.error("getFingerabdruck(" + file.getName() + ")", iOException);
            return 0L;
        }
    }
}

